 ; Ŀ
 ;   Extro: Get text, sort by position, write to a file.                   
 ;   Copyright 1994, 2005, 2006 by Rocket Software Ltd.                    
 ;   It's probably a good thing that bats don't make honey.                
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Tbc - text indicator.                                      
 ;   Arguments: Enam, a text entity name.                                  
 ;              Colo, a grdraw colour.                                     
 ;   Calls nothing, returns the geometrical midpoint of the text.          
 ; 
 (DEFUN TBC (enam colo / entt bb rota cc dd bheigt bwidth llangg lldist ll ul
                                                                        lr ur)
  (setq entt (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox entt))
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points.            
 ; 
  (grdraw ll ur colo 1)
  (grdraw ul lr colo 1)
 ; Ŀ
 ;   Return the midpoint.                                                  
 ; 
 (polar ll (angle ll ur) (/ (distance ll ur) 2)))
 ; Ŀ
 ;   Subroutine Tbc end.                                                   
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Extro.                                                                
 ; 
 (DEFUN C:EXTRO (/ num ss enam ordlst filnam fn pa pb)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get an ss of text, order it by position.                              
 ; 
  (if (setq ss (ssget (list (cons 0 "text"))))
      (progn
           (setq ordlst (vtol ss nil t))
 ; Ŀ
 ;   Get a data file name.                                                 
 ;   The 37 flag allows an existing or new file name to be entered.        
 ; 
           (if (/= (type filnam) 'STR)
               (setq filnam ""))
           (setq filnam (getfiled "Text Output File" filnam "" 37))
 ; Ŀ
 ;   Write the strings out to a text file.                                 
 ; 
           (setq fn (Open filnam "w"))
           (setq num 0)
           (while (setq enam (nth num ordlst))
                  (write-line (cdr (assoc 1 (entget enam))) fn)
                  (tbc enam 160)
                  (setq pa (spit (entget enam)))
                  (if (and pa pb)
                      (grdraw pa pb 160 1))
                  (setq pb pa)
                  (setq num (1+ num)))
           (close fn)))
 (princ))